//%attributes = {}
// Method: ldcap_ DAY_LOAD_GET
// 2008.12.22-19:42:19 / Pasi Mankinen
// © Copyright 2008 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_TEXT:C284($2; $ld_tLoadGroup)
C_LONGINT:C283($1; $ld_lAction; $5; $ld_lGetPreviousWorks; $8; $ld_lCalcLoadFromCriticalDate)
C_LONGINT:C283($ld_lIndex; $ld_lIndex2; $ld_lRunLoop)
C_POINTER:C301($6; $ld_pCapacity; $7; $ld_pLoaded)
C_DATE:C307($3; $ld_dStartDay; $4; $ld_dEndDay)

C_REAL:C285($ld_rDayCapacity; $ld_rDayLoad)  //values to return
C_LONGINT:C283($ld_lIndex; $ld_dStartDayStartIndex)
C_REAL:C285($ld_rPhaseLoad; $ld_rCapacity; $ld_rMultiplier; $ld_rCapacityStartDateTime; $ld_rCapacityEndDateTime)

$ld_lAction:=$1
$ld_tLoadGroup:=$2
$ld_dStartDay:=$3
$ld_dEndDay:=$4
$ld_lGetPreviousWorks:=$5
$ld_pCapacity:=$6
$ld_pLoaded:=$7
$ld_lCalcLoadFromCriticalDate:=$8

COMPILER_ldcap_

Case of 
	: ($ld_lAction=kInit)
		//week does not matter, only cap start date
		ld_WORK_ARR_LOAD($ld_tLoadGroup; kFalse; kFalse; kFalse)
		ldcap_FREE_CACLULATE(ld_tLoad_Group_id; 0; $ld_lCalcLoadFromCriticalDate)  //;ld_dCapacityStartDate;ld_hCapacityStartTime)
		
	: ($ld_lAction=kGet)
		$ld_rPhaseLoad:=0
		$ld_rDayLoad:=0
		$ld_rDayCapacity:=0
		If (Size of array:C274(ldcap_arCapacity)>0)
			$ld_dStartDayStartIndex:=Find in array:C230(ldcap_adStartDate; $ld_dStartDay)  //find start
			If ($ld_dStartDayStartIndex<=0)
				If (False:C215)  //this is normal case in daily capacity
					_err MESSAGE(_lang Current("Day capacity was not found")+" ("+$ld_tLoadGroup+"/"+_date ToString($ld_dStartDay)+")"; Current method name:C684; kFalse)
				End if 
			Else 
				//---------- calculate capacity first ----------
				$ld_lIndex:=$ld_dStartDayStartIndex
				If ($ld_lIndex>1)  //this is before while loop, so comes only once
					If (ldcap_adEndDate{$ld_lIndex-1}>=$ld_dStartDay)  //Previous capacity ends on this date
						$ld_lIndex:=$ld_lIndex-1
					End if 
				End if 
				
				While ($ld_lIndex>0)
					
					//get one phase capacity            
					Case of 
						: ($ld_lGetPreviousWorks=kTrue)
							$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}
							//previous works always to this weeks full cap from monday
							//even if we are already in the middle of week
						: (ldcap_adStartDate{$ld_lIndex}<ldcap_dCapacityStartDate)
							$ld_rCapacity:=0
							//: (ldcap_adStartDate{$ld_lIndex}=ldcap_dCapacityStartDate)
							//    capacity is agreed to come from day start, not from current time
						Else 
							$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}  // ld_arCapCapacity is already multiplied to effective
					End case 
					
					//get week capacity
					$ld_rMultiplier:=1
					Case of 
						: ($ld_lIndex>=$ld_dStartDayStartIndex)  //normal cases
							$ld_rDayCapacity:=$ld_rDayCapacity+$ld_rCapacity
						: (ldcap_adEndDate{$ld_lIndex}>=$ld_dStartDay)  //Previous capacity ends on this week
							$ld_rCapacityStartDateTime:=ldcap_arStart{$ld_lIndex}
							$ld_rCapacityEndDateTime:=ldcap_arEnd{$ld_lIndex}
							$ld_rDayDateTime:=_dt ToReal($ld_dStartDay; ?00:00:00?)
							If ($ld_rCapacityEndDateTime>$ld_rCapacityStartDateTime)
								If ($ld_rCapacityEndDateTime>$ld_rDayDateTime)
									$ld_rMultiplier:=($ld_rCapacityEndDateTime-$ld_rDayDateTime)/($ld_rCapacityEndDateTime-$ld_rCapacityStartDateTime)
								Else 
									$ld_rMultiplier:=0
								End if 
							Else 
								$ld_rMultiplier:=0
							End if 
							$ld_rDayCapacity:=$ld_rDayCapacity+($ld_rCapacity*$ld_rMultiplier)
						Else 
							IDLE:C311  //last capacity goes to next week is handled below in code
					End case 
					
					$ld_lIndex:=$ld_lIndex+1  //check next capacity
					Case of 
						: ($ld_lIndex>Size of array:C274(ldcap_adStartDate))
							$ld_lIndex:=-1  //end loop
							//error message here!!!
						: (ldcap_adStartDate{$ld_lIndex}>$ld_dEndDay)
							//week end reached, next capacity start date after this week
							$ld_lIndex:=-1  //end loop
							
						: (ldcap_adEndDate{$ld_lIndex}>$ld_dEndDay)
							//Last capacity ends on next week - take this week part of load & capacity
							$ld_rCapacityStartDateTime:=ldcap_arStart{$ld_lIndex}
							$ld_rCapacityEndDateTime:=ldcap_arEnd{$ld_lIndex}
							$ld_rDayDateTime:=_dt ToReal($ld_dEndDay; ?24:00:00?)  // ak 2014-02-27: $ld_rWeeDateTime :=_dt ToReal ($ld_dEndDay;?24:00:00?)
							If ($ld_rCapacityEndDateTime>$ld_rCapacityStartDateTime)
								If ($ld_rDayDateTime>$ld_rCapacityStartDateTime)
									$ld_rMultiplier:=($ld_rDayDateTime-$ld_rCapacityStartDateTime)/($ld_rCapacityEndDateTime-$ld_rCapacityStartDateTime)
									$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}*$ld_rMultiplier
									$ld_rDayCapacity:=$ld_rDayCapacity+$ld_rCapacity
								End if 
							End if 
							//*** Calculate this week part ***
							$ld_lIndex:=-1  //end loop
						Else 
							IDLE:C311  //normal case when we are not in the last capacity of the week
					End case 
					
				End while 
				
				
				//---------- calculate load  ---------- 
				
				$ld_dCapStartDate:=ldcap_dCapacityStartDate
				If ($ld_lGetPreviousWorks=kTrue)
					//set week start to capacity start date, everything before is in previous weeks so
					//we need to get date previous from current date to get previous loading
					//or current date's index where to start calculatin load (later after this if)
					
					
					If (ldcap_dCapacityStartDate<$ld_dStartDay)
						IDLE:C311  //before:  $ld_dCapStartDate:=ldcap_dCapacityStartDate
					Else 
						$ld_dCapStartDate:=$ld_dStartDay
					End if 
					$ld_lIndex:=ldcap_IndexFirst($ld_tLoadGroup; $ld_dCapStartDate)
					$ld_lIndex:=$ld_lIndex-1
					
					//calculate previous weeks loading, including this weeks past dates
					//it's cumulative free = load before this day
					$ld_rDayLoad:=-ldcap_arCumulativeFree{$ld_lIndex}  //here is the result we need
					
					If ($ld_lIndex<($ld_dStartDayStartIndex-1))
						If ($ld_lIndex<Size of array:C274(ldcap_adStartDate))
							$ld_dStartDayStartIndex:=$ld_lIndex+1
							If (ldcap_adStartDate{$ld_dStartDayStartIndex}<$ld_dStartDay)
								$ld_lGetPreviousWorks:=kFalse  //calculate next need from cap start date to start date
								$ld_dEndDay:=$ld_dStartDay-1
							End if 
						End if 
					End if 
					
				End if 
				
				
				If ($ld_lGetPreviousWorks=kFalse)
					//calculate only weeks(remaining) loading
					//load is calculated by one phase at a time and basic formula is: 
					//load = ldcap_arCapacity{$ld_lIndex} - ldcap_arCurrentFree{$ld_lIndex}
					
					If ($ld_dCapStartDate<$ld_dStartDay)
						$ld_lIndex:=$ld_dStartDayStartIndex  //calculate next need from cap start date to start date
					Else 
						$ld_lIndex:=ldcap_IndexFirst($ld_tLoadGroup; $ld_dStartDay)
					End if 
					// If ($ld_lIndex>1)  `this is before while loop, so comes only once
					//            If (ldcap_adEndDate{$ld_lIndex-1}>=$ld_dStartDay)  `Previous 
					//~capacity ends on this week
					//              $ld_lIndex:=$ld_lIndex-1
					//            End if 
					//          End if  
					
					$ld_rMultiplier:=1  //only part of the day if phase is not fully inside needed time from start or end
					While ($ld_lIndex>0)
						
						//get one phase capacity         
						
						If (ldcap_adStartDate{$ld_lIndex}<ldcap_dCapacityStartDate)
							$ld_rCapacity:=0
						Else 
							$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}  // ld_arCapCapacity is already multiplied to effective
						End if 
						//            $ld_rMultiplier:=($ld_rCapacityEndDateTime-$ld_rDayDateTime)/($ld
						//~_rCapacityEndDateTime-$ld_rCapacityStartDateTime)'                        
						$ld_rPhaseLoad:=($ld_rCapacity*$ld_rMultiplier)-(ldcap_arCurrentFree{$ld_lIndex}*$ld_rMultiplier)
						$ld_rDayLoad:=$ld_rDayLoad+$ld_rPhaseLoad
						
						$ld_lIndex:=$ld_lIndex+1
						Case of   //check next capacity
							: ($ld_lIndex>Size of array:C274(ldcap_adStartDate))
								$ld_lIndex:=-1
								//error message here!!!
							: (ldcap_adStartDate{$ld_lIndex}>$ld_dEndDay)
								//week end reached, next capacity start date after this week
								$ld_lIndex:=-1  //end loop
								
							: (ldcap_adEndDate{$ld_lIndex}>$ld_dEndDay)
								//Last capacity ends on next week - take this week part of load & capacity
								$ld_rCapacityStartDateTime:=ldcap_arStart{$ld_lIndex}
								$ld_rCapacityEndDateTime:=ldcap_arEnd{$ld_lIndex}
								$ld_rDayDateTime:=_dt ToReal($ld_dEndDay; ?24:00:00?)
								If ($ld_rCapacityEndDateTime>$ld_rCapacityStartDateTime)
									If ($ld_rDayDateTime>$ld_rCapacityStartDateTime)
										$ld_rMultiplier:=($ld_rDayDateTime-$ld_rCapacityStartDateTime)/($ld_rCapacityEndDateTime-$ld_rCapacityStartDateTime)
										$ld_rCapacity:=ldcap_arCapacity{$ld_lIndex}*$ld_rMultiplier
										$ld_rDayCapacity:=$ld_rDayCapacity+$ld_rCapacity
										$ld_rPhaseLoad:=$ld_rCapacity-(ldcap_arCurrentFree{$ld_lIndex}*$ld_rMultiplier)
										$ld_rDayLoad:=$ld_rDayLoad+$ld_rPhaseLoad
									Else 
										IDLE:C311
									End if 
								End if 
								//*** Calculate this week part ***
								$ld_lIndex:=-1  //end loop
							Else 
								IDLE:C311
						End case 
						
					End while 
				End if 
				
			End if 
		End if 
		
		If ($ld_rDayLoad<0)
			$ld_rDayLoad:=0
		End if 
		$ld_pCapacity->:=$ld_rDayCapacity
		$ld_pLoaded->:=$ld_rDayLoad
	Else 
		_err MESSAGE_PARAMETER("$1"; Current method name:C684; kFalse)
End case 

